/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.core.model;

import com.aptana.index.core.CategoryInfo;
import com.aptana.index.core.Index;
import com.aptana.js.core.inferencing.JSTypeUtil;
import com.aptana.js.core.model.BaseElement;
import com.aptana.js.core.model.ClassElement;
import com.aptana.js.core.model.TypeElement;
import com.aptana.js.internal.core.index.JSIndexReader;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassGroupElement
extends BaseElement {
    private Index index;
    private List<ClassElement> classes;
    private int typeCount = -1;
    private CategoryInfo typeInfo;
    private CategoryInfo propertyInfo;
    private CategoryInfo functionInfo;

    public ClassGroupElement(String name, Index index) {
        this.index = index;
        this.setName(name);
    }

    public int getClassCount() {
        if (this.typeCount == -1) {
            JSIndexReader reader = new JSIndexReader();
            List<String> typeNames = reader.getTypeNames(this.index);
            HashSet<String> mergedTypeNames = new HashSet<String>();
            for (String typeName : typeNames) {
                boolean isClassType = JSTypeUtil.isClassType(typeName);
                String baseName = isClassType ? JSTypeUtil.getClassType(typeName) : typeName;
                mergedTypeNames.add(baseName);
            }
            this.typeCount = mergedTypeNames.size();
        }
        return this.typeCount;
    }

    public List<ClassElement> getClasses() {
        if (this.classes == null) {
            JSIndexReader reader = new JSIndexReader();
            List<TypeElement> types = reader.getTypes(this.index, true);
            this.classes = JSTypeUtil.typesToClasses(types);
        }
        return this.classes;
    }

    public CategoryInfo getFunctionInfo() {
        if (this.functionInfo == null) {
            JSIndexReader reader = new JSIndexReader();
            this.functionInfo = reader.getCategoryInfo(this.index, "js.function");
        }
        return this.functionInfo;
    }

    public CategoryInfo getPropertyInfo() {
        if (this.propertyInfo == null) {
            JSIndexReader reader = new JSIndexReader();
            this.propertyInfo = reader.getCategoryInfo(this.index, "js.property");
        }
        return this.propertyInfo;
    }

    public CategoryInfo getTypeInfo() {
        if (this.typeInfo == null) {
            JSIndexReader reader = new JSIndexReader();
            this.typeInfo = reader.getCategoryInfo(this.index, "js.type");
        }
        return this.typeInfo;
    }

    public boolean hasChildren() {
        return this.getTypeInfo().count > 0;
    }
}

